% Section 6.7 Tutorial Example, Observer & Controller design
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System
A = [    0         0    1.0000         0      0
         0   -0.1540   -0.0042    1.5400      0
         0    0.2490   -1.0000   -5.2000      0
    0.0386   -0.9960   -0.0003   -0.1170      0
         0    0.5000         0         0   -0.5]; 
     
B = [    0         0
   -3.7200   -0.1600
    1.6850   -5.6000
    0.1000         0
         0         0]; 
     
F = [    0
   -3.7200
    1.6850
    0.1000
         0];
     
D = [0 0;1 1;0 1;1 0;0 0];
C = [0 1 0 0 0;0 0 0 1 1;1 1 1 0 0]; 

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

% Uncertainty
Ap = [   0         0         0         0      0
         0   -0.1540   -0.0042    1.5400      0
         0    0.2490   -1.0000   -5.2000      0
    0.0386   -0.9960   -0.0003   -0.1170      0
         0    0.5000         0         0   -0.5];
     
delta1 = 0.9;
Nc = delta1*eye(n);
Mc = 1/delta1*0.05*Ap;
Delta_A = Mc*Nc;

% Augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
B_bar = [B;zeros(q,m);zeros(q,m)];
C_bar = [C zeros(p,q) zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) zeros(q,q); zeros(q,l) eye(q)];


% baseline control 
Cx = eye(n);
V0 = 1.0e0*eye(m);
alpha1 = 1.0e2; alpha2 = 1.0e1;
[K0,W0,gamma10,obj20] = Initial_controller_design(A,B,D,Nc,Mc,Cx,V0,alpha1,alpha2)

% 
% load('K0.mat');
% load('gamma10.mat');
% load('W0.mat');
% load('obj20.mat');

aa = 1.0e0;
V0 = aa^2*eye(m);
Sk = inv(W0'*W0);
Rk = inv(V0);

%Weights
alpha1 = 1.0e2; alpha2 = 1.0e1;
beta1 = 5.0e1; beta2 = 1.0e0;

%Stop criteria
epsilon = 1.0e-5;
maxJ = 50;

Istept(1) = 0;
gamma_t(1) = gamma10; 
Wt{1} = W0;
TrW(1) = trace(W0'*W0);
Vt{1} = sqrt(V0);
TrV(1) = trace(V0);
obj2(1) = obj20;

 
for j=1:maxJ
      
    j
    Istept(j+1) = j;
    Istep(j) = j;   
  
    % Solve optimization problem P1
   [gamma2(j),Lt{j},delta(j),R,obj1(j)] = Optimization_P1(A,B,F,D,C,Mc,Nc,beta1,beta2,K0,Rk,Sk); 

   V0 = inv(R) + V0;
    Vt{j+1} = sqrt(V0);
    TrV(j+1) = trace(V0);
    Rk = inv(V0);
    
    % Solve optimization problem P2
   [obj2(j+1),gamma1(j),Kt{j},S] = Optimization_P2(A,B,F,D,C,Mc,Nc,alpha1,alpha2,Rk);
   
   W0 = sqrt(inv(S));
   Wt{j+1} = W0;
   TrW(j+1) = trace(W0'*W0);
   gamma_t(j+1) = gamma1(j);
   Sk = S;

    sigma(j) = abs(obj2(j+1) - obj2(j))/obj2(j);
  
    if sigma(j) < epsilon
       disp('Iteration terminates at:');
       break;       
   end  
end

% Save data
j_star = j
 gamma1_star = gamma1(j)
 K = Kt{j};
 L = Lt{j};
 W = Wt{j+1};
 V = Vt{j+1}; 

save j_star.mat j_star
save gamma1_star.mat gamma1_star
save K.mat K
save L.mat L
save W.mat W
save V.mat V

% Draw figure
run('Draw_figure1.m');
